#!/home/john/bin/python2.7
#

import os

from   starbase    import *
from   SAOETC_Calc import *

def main() :
    seterr(all='raise')

    if ( "REQUEST_METHOD" in os.environ ) :
	    import cgi
	    import dotable

	    options = dotable.Dotable()

	    form = cgi.FieldStorage()

	    options.redshift	= float(form.getvalue("redshift"))
	    options.abmag	= float(form.getvalue("ABmag"))
	    options.srcext	= float(form.getvalue("srcext"))
	    options.exptime	= float(form.getvalue("exptime"))
	    options.subexp	= float(form.getvalue("subexp"))
	    options.bkgratio	= float(form.getvalue("bkgratio"))
	    options.seeing	= float(form.getvalue("seeing"))
	    options.aptype	= form.getvalue("aptype")
	    options.apwidth	= float(form.getvalue("apwidth"))
	    options.apheight	= float(form.getvalue("apheight"))
	    options.bkaptype	= form.getvalue("bkaptype")
	    options.bkapwidth	= float(form.getvalue("bkapwidth"))
	    options.bkapheight	= float(form.getvalue("bkapheight"))
	    options.moon	= form.getvalue("moon")
	    options.smscale	= float(form.getvalue("smscale"))
	    options.transcut	= float(form.getvalue("transcut"))
	    options.format	= form.getvalue("format", default="json")
	    options.skymask	= form.getvalue("skymask", default="off")
	    options.vector	= form.getvalue("vector", default="spec")
	    options.rand        = "yes"
	    
	    transmiss= "EffArea/cptrans_zm_43_10.txt"
	    instmode = "EffArea/" + form.getvalue("instmode")	+ ".tab"
	    objspec  = "Spectra/" + form.getvalue("objspec")
	    skybkgd  = "Bkgd/"    + "skybkgd.tab"

    else :
	    from optparse import OptionParser

	    ap = OptionParser()

	    ap.add_option("--redshift",	type="float",  default=0.0)
	    ap.add_option("--abmag",	type="float",  default=23.0)

	    ap.add_option("--srcext",	type="float",  default=0.0)
	    ap.add_option("--exptime", 	type="float",  default=3600.0)
	    ap.add_option("--subexp", 	type="float",  default=300)
	    ap.add_option("--bkgratio", 	type="float",  default=1)
	    ap.add_option("--seeing", 	type="float",  default=0.4)
	    ap.add_option("--aptype", 	type="choice", default="Square", choices=["Round", "Square", "Rectangular"])
	    ap.add_option("--apwidth", 	type="float",  default=0.5)
	    ap.add_option("--apheight", type="float",  default=1.0)
	    ap.add_option("--bkaptype", type="choice", default="Square", choices=["Round", "Square", "Rectangular"])
	    ap.add_option("--bkapwidth",type="float",  default=0.5)
	    ap.add_option("--bkapheight",type="float",  default=1.0)
	    ap.add_option("--moon", 	type="string", default="Dark")
	    ap.add_option("--smscale",	type="float",  default=10)
	    ap.add_option("--skymask",	type="choice", default="no",	 choices=["yes", "no"])
	    ap.add_option("--transcut", type="float",  default=0.75)
	    ap.add_option("--format",	type="choice", default="table",	 choices=["table", "json", "none"])
	    ap.add_option("--vector",	type="choice", default="spec",	 choices=["spec", "flux"])
	    ap.add_option("--rand",	type="choice", default="yes",	 choices=["yes", "no"])

	    (options, args) = ap.parse_args()

	    if ( len(args) <> 4 ) :
		print "SAOETC_cmd [options] instmode objspec skybackground"
		exit(1)

	    transmiss= args[0]
	    instmode = args[1]
	    objspec  = args[2]
	    skybkgd  = args[3]

    if ( options.format == "table" ) :
	    print 'SAO Exposure Time Calculator : v0.5'
	    print ''
	    print 'transmiss	{}'.format(transmiss)
	    print 'instmode	{}'.format(instmode)
	    print 'objspec 	{}'.format(objspec)
	    print 'skybkgd 	{}'.format(skybkgd)
	    print 'redshift	{}'.format(options.redshift)
	    print 'abmag   	{}'.format(options.abmag)
	    print 'srcext  	{}'.format(options.srcext)
	    print 'seeing  	{}'.format(options.seeing)
	    print 'exptime 	{}'.format(options.exptime)
	    print 'subexp  	{}'.format(options.subexp)
	    print 'bkgratio	{}'.format(options.bkgratio)
	    print 'smscale 	{}'.format(options.smscale)
	    print 'aptype  	{}'.format(options.aptype)
	    print 'apwidth 	{}'.format(options.apwidth)
	    print 'apheight	{}'.format(options.apheight)
	    print 'bkaptype	{}'.format(options.bkaptype)
	    print 'bkapwidth	{}'.format(options.bkapwidth)
	    print 'bkapheight	{}'.format(options.bkapheight)
	    print 'transcut	{}'.format(options.transcut)
	    print 'rand     	{}'.format(options.rand)

	    print ''

    try:
	    (minx, maxx, p1miny, p1maxy, p2miny, p2maxy, p3miny, p3maxy,
	     ABFile, wave, sn, smspec, smspec_mask, flux, flux_mask,
	    pixscale, apix) = Calc(
		    transmiss,
		    instmode,
		    objspec,
		    skybkgd,
		    options.redshift,
		    options.abmag,
		    options.srcext,
		    options.aptype,
		    options.apwidth,
		    options.apheight,
		    options.seeing,
		    options.exptime,
		    options.subexp,
		    options.bkgratio,
		    options.smscale,
		    options.bkaptype,
		    options.bkapwidth,
		    options.bkapheight,
		    options.transcut,
		    options.rand)

    except:
	    if ( options.format == "json" ) :
		print '{ "message" : "an error occured during the calculation" }'
	    else :
		raise

	    exit(0)
	    


    if ( options.format == "json" ) :
	    print '{'
	    print '  "minx":   {},'.format(  minx)
	    print '  "maxx":   {},'.format(  maxx)
	    print '  "p1miny": {},'.format(p1miny)
	    print '  "p1maxy": {},'.format(p1maxy)
	    print '  "ABFile": {},'.format(ABFile)

	    print '  "wav": [' + ','.join(['{0:.4f}'.format(x) for x in wave])     + '],'
	    print '  "snr": [' + ','.join(['{0:.4f}'.format(x) for x in   sn])     + '],'

	    if ( options.vector == "spec" ) :
		print '  "p2miny": {},'.format(p2miny)
		print '  "p2maxy": {},'.format(p2maxy)
		if ( options.skymask == "off" ) :
		    print '  "spc": [' + ','.join(['{0:.4}'.format(x) if x != "masked"
				    else '"*"' for x in smspec]) + ']'
		else :
		    print '  "spc": [' + ','.join(['{0:.4}'.format(x) if x != "masked"
				    else '"*"' for x in smspec_mask]) + ']'
	    else :
		print '  "p2miny": {},'.format(p3miny)
		print '  "p2maxy": {},'.format(p3maxy)
		if ( options.skymask == "off" ) :
		    print '  "spc": [' + ','.join(['{0:.4}'.format(x) if x != "masked"
				    else '"*"' for x in flux]) + ']'
		else :
		    print '  "spc": [' + ','.join(['{0:.4}'.format(x) if x != "masked"
				    else '"*"' for x in flux_mask]) + ']'

	    print '}'

    if ( options.format == "table" ) :
	    table = Starbase.arrays("Wave", wave, "Spec", smspec, "Clip", smspec_mask,
						  "Flux", flux, "FluxMask", flux_mask, "SNR", sn)

	    print table


if __name__ == "__main__":
    if ( len(sys.argv) > 1 and sys.argv[1] == "profile" ) :
	del sys.argv[1]

	import cProfile
	cProfile.run('main()')
    else : 
        main()

