#!/usr/local/bin/python2.7
#

import glob, os

from numpy import *
import Tkinter    as Tk
import matplotlib as plt
from scipy.integrate import dblquad

from   starbase    import *
from   SAOETC_Calc import *

plt.use('TkAgg')
from matplotlib.figure import Figure
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg

specdir="Spectra/"
instdir="EffArea/"
bkgddir="Bkgd/"

def Plot() : 
   (minx, maxx, p1miny, p1maxy, p2miny, p2maxy, p3miny, p3maxy,
    ABmag, wave, sn, smspec, rspecn, smspec_mask, fluxout, fluxout_mask,
    pixscale, apix) = Calc(
                instdir + "cptrans_zm_43_10.txt",
		instdir + instmode.get() + ".tab",
		specdir + speccat.get() + "/" +  objspec.get()  + ".tab",
		bkgddir + "skybkgd.tab", 
		redshift.get(),
		bandnorm.get(),
		instdir + bandfilt.get() + ".mag",
		srcextent.get(),
		aptype.get(), apdim1.get(), apdim2.get(),
		seeing.get(),
		moonage.get(), airmass.get(),
		exptime.get(),
		smscale.get(),
		transcut.get(), 1)



   ABfile.set(ABmag)
   angsperpix.set(apix)
   arcperpix.set(pixscale)

   if plscale.get() >= 0.0:
      p2maxy=plscale.get()

   # Make the plots
   #
   p.cla()                     # Clear all

   #  p.set_title("Photons")
   #
   p.set_ylabel("SN per res element")
   p.set_xlabel("Wavelength")

   p.plot(wave,sn)# Plot the data
   p.axis([minx,maxx,p1miny,p1maxy])
   dataPlot.show()              # Show the plot

   o.cla()                     # Clear all

   #  o.set_title("Photons")
   #
   o.set_ylabel("Photons per pixel")
   o.set_xlabel("Wavelength")

   o.plot(wave,smspec)# Plot the data   
   o.plot(wave,rspecn)#plot the noise

   o.axis([minx,maxx,p2miny,p2maxy])
   dataPlot.show()              # Show the plot

def Plotflx() : 
   (minx, maxx, p1miny, p1maxy, p2miny, p2maxy, p3miny, p3maxy,
    ABmag, wave, sn, smspec, rspecn, smspec_mask, fluxout, fluxout_mask,
    pixscale, apix) = Calc(
                instdir + "cptrans_zm_43_10.txt",
		instdir + instmode.get() + ".tab",
		specdir + speccat.get() + "/" +  objspec.get()  + ".tab",
		bkgddir + "skybkgd.tab", 
		redshift.get(),
		bandnorm.get(),
		instdir + bandfilt.get() + ".mag",
		srcextent.get(),
		aptype.get(), apdim1.get(), apdim2.get(),
		seeing.get(),
		moonage.get(), airmass.get(),
		exptime.get(),
		smscale.get(),
		transcut.get(), 1)


   ABfile.set(ABmag)
   arcperpix.set(pixscale)
   angsperpix.set(apix)
   
   if plscale.get() >= 0.0:
      p3maxy=plscale.get()

   # Make the plots
   #
   p.cla()                     # Clear all

   #  p.set_title("ergs cm(-2) s(-1) A(-1)")
   #
   p.set_ylabel("SN per res element")
   p.set_xlabel("Wavelength")

   p.plot(wave,sn)		# Plot the data
   p.axis([minx,maxx,p1miny,p1maxy])
   dataPlot.show()              # Show the plot

   o.cla()                     # Clear all

   #  o.set_title("ergs cm(-2) s(-1) A(-1)")
   #
   o.set_ylabel("ergs cm(-2) s(-1) A(-1)")
   o.set_xlabel("Wavelength")

   o.plot(wave,fluxout)		# Plot the data      

   o.axis([minx,maxx,p3miny,p3maxy])
   dataPlot.show()              # Show the plot


def configui(w=None):
   if aptype.get() == "Rectangular":
      wlAWidth.configure(text="Aperture Width (arcsec)")
   elif aptype.get() == "Round":
      wlAWidth.configure(text="Aperture Dia   (arcsec)")
   elif aptype.get() == "Square":
      wlAWidth.configure(text="Aperture Width   (arcsec)")
      
   if aptype.get() == "Rectangular":
      wlAHeight.grid()
      weAHeight.grid()
   else:
      wlAHeight.grid_remove()
      weAHeight.grid_remove()


def specset(w):
   Spectra=[os.path.splitext(os.path.basename(x))[0] for x in glob.glob(specdir+speccat.get()+"/*.tab")]
   Spectra.sort()

   wSpectra["menu"].delete(0, Tk.END)
   for item in Spectra:
      wSpectra["menu"].add_command(label=item, command=lambda item=item: wSpectra.setvar(wSpectra.cget("textvariable"), value=item))

   objspec.set(Spectra[0])


def setredrange(w):
 #   print "Here"
    pass

      
# Build a user interface.
#
frame = Tk.Tk()

# This is the top row of the controls

Tk.Button(frame, text="Plot Photons", command=Plot).grid(row=1,column=1)
Tk.Button(frame, text="Plot Flux", command=Plotflx).grid(row=2,column=1)

speccat = Tk.StringVar()
Tk.Label(frame, text="Spectrum Type" ).grid(row=1,column=2)

SpecCat=[os.path.splitext(os.path.basename(x))[0] for x in glob.glob(specdir + "*")]
SpecCat.sort()

speccat = Tk.StringVar()
speccat.set(SpecCat[0])
Tk.OptionMenu(frame, speccat, *SpecCat, command=specset).grid(row=1, column=3)

Spectra=[os.path.splitext(os.path.basename(x))[0] for x in glob.glob(specdir+speccat.get()+"/*.tab")]
Spectra.sort()


# Example of String variable valued option menu
#
objspec = Tk.StringVar()
objspec.set(Spectra[0])
Tk.Label(frame, text="Spectrum" ).grid(row=1,column=4)
wSpectra = Tk.OptionMenu(frame, objspec, *Spectra, command=setredrange)
wSpectra.grid(row=1, column=5)


# Example of Integer variable valued Entry Box
#
smscale = Tk.IntVar()
smscale.set(10)
Tk.Label(frame, text="Boxcar Smooth Pixels" ).grid(row=2,column=4)
Tk.Entry(frame, textvariable=smscale).grid(row=2, column=5)


Instruments = [os.path.splitext(os.path.basename(x))[0] for x in glob.glob(instdir+"*.tab")]
Instruments.sort()

instmode = Tk.StringVar()
instmode.set(Instruments[0])
Tk.Label(frame, text="Instrument & Mode" ).grid(row=2,column=2)
Tk.OptionMenu(frame, instmode, *Instruments).grid(row=2, column=3)

redshift = Tk.DoubleVar()
redshift.set(0.)
Tk.Label(frame, text="Redshift" ).grid(row=3,column=1)
Tk.Entry(frame, textvariable=redshift).grid(row=3,column=2)


transcut = Tk.DoubleVar()
transcut.set(0.75)
#Tk.Label(frame, text="Atmos Transmission Cut" ).grid(row=3,column=5)
#Tk.Entry(frame, textvariable=transcut).grid(row=3,column=6)

ABfile = Tk.DoubleVar()
#wlNorm=Tk.Label(frame, text="File AB Magnitude" )
#wlNorm.grid(row=4,column=1)
#Tk.Entry(frame, textvariable=ABfile).grid(row=4,column=2)

angsperpix = Tk.DoubleVar()
#wlNorm=Tk.Label(frame, text="Angstroms per pixel" )
#wlNorm.grid(row=4,column=5)
#Tk.Entry(frame, textvariable=angsperpix).grid(row=4,column=6)

arcperpix = Tk.DoubleVar()
#wlNorm=Tk.Label(frame, text="Arcsec per pixel" )
#wlNorm.grid(row=5,column=5)
#Tk.Entry(frame, textvariable=arcperpix).grid(row=5,column=6)

bandnorm = Tk.DoubleVar()
bandnorm.set(23.)
wlNorm=Tk.Label(frame, text="AB Magnitude in Observed Band" )
wlNorm.grid(row=4,column=3)
Tk.Entry(frame, textvariable=bandnorm).grid(row=4,column=4)

MagBands = [os.path.splitext(os.path.basename(x))[0] 
for x in glob.glob(instdir+"*.mag")]
MagBands.sort()

bandfilt = Tk.StringVar()
bandfilt.set(MagBands[0])
Tk.Label(frame, text="Magnitude Band" ).grid(row=5,column=3)
Tk.OptionMenu(frame, bandfilt, *MagBands).grid(row=5, column=4)

exptime = Tk.DoubleVar()
exptime.set(3600.)
Tk.Label(frame, text="Exposure Time (sec)" ).grid(row=5,column=1)
Tk.Entry(frame, textvariable=exptime).grid(row=5,column=2)


srcextent = Tk.DoubleVar()
srcextent.set(0.5)
Tk.Label(frame, text="Source Effective Radius (arcsec)" ).grid(row=6,column=1)
Tk.Entry(frame, textvariable=srcextent).grid(row=6,column=2)

seeing = Tk.DoubleVar()
seeing.set(1.0)
Tk.Label(frame, text="Seeing FWHM (arcsec)" ).grid(row=7,column=1)
Tk.Entry(frame, textvariable=seeing).grid(row=7,column=2)

aptype = Tk.StringVar()
aptype.set("Square")
Tk.Label(frame, text="Aperture Type" ).grid(row=8,column=1)
Tk.OptionMenu(frame, aptype, "Square", "Round",
   "Rectangular", command=configui ).grid(row=8, column=2)

moonage = Tk.DoubleVar()
moonage.set(7)
Tk.Label(frame, text="Moon Age" ).grid(row=7,column=3)
Tk.OptionMenu(frame, moonage, 0, 3, 7, 10, 14).grid(row=7, column=4)


airmass = Tk.DoubleVar()
airmass.set(1.0)
Tk.Label(frame, text="Airmass" ).grid(row=8,column=3)
Tk.Entry(frame, textvariable=airmass).grid(row=8,column=4)



apdim1 = Tk.DoubleVar()
apdim1.set(0.5)
wlAWidth=Tk.Label(frame, text="Aperture Width (arcsec)" )
wlAWidth.grid(row=9,column=1)
Tk.Entry(frame, textvariable=apdim1).grid(row=9,column=2)

apdim2 = Tk.DoubleVar()
apdim2.set(1.0)
wlAHeight=Tk.Label(frame, text="Aperture Height (arcsec)" )
wlAHeight.grid(row=10,column=1)
weAHeight=Tk.Entry(frame, textvariable=apdim2)
weAHeight.grid(row=10,column=2)

plscale = Tk.DoubleVar()
plscale.set(-1.)
Tk.Label(frame, text="Spec Plot Y Scale Max" ).grid(row=11,column=1)
Tk.Entry(frame, textvariable=plscale).grid(row=11,column=2)

# Make the plot window
#
f = Figure(figsize=(16,6), dpi=80)
f.subplots_adjust(top=.95, bottom=.15)

p = f.add_subplot(211)
#p.set_title("Results")
p.set_ylabel("SNR per pixel")
p.set_xlabel("Wavelength")

o = f.add_subplot(212)
#o.set_title("Results")
o.set_ylabel("Spectrum")
o.set_xlabel("Wavelength")

dataPlot = FigureCanvasTkAgg(f, master=frame)
dataPlot.get_tk_widget().grid(row=15,column=1,columnspan=7)

# Enter the user interface interactive loop
#
configui()
Tk.Tk.mainloop(frame)
